// $Id: CBitmapImage.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CBitmapImage.hpp"
#include <Exceptions/CException.hpp>
using Exponent::GUI::Graphics::CBitmapImage;
using Exponent::Exceptions::CException;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CBitmapImage, CBaseImage);

//	===========================================================================
CBitmapImage::CBitmapImage(const CSystemString &filename)
{
	EXPONENT_CLASS_CONSTRUCTION(CBitmapImage);
	m_hasAlpha = false;
	if (!this->loadFromFile(filename))
	{
		CString message = "Failed to load ";
		message.appendString(filename.getString());
		message.appendString("\nThe reason was : ");
		message.appendString(m_lastError);
		throw CException(message, "CTGAImage::CTGAImage(const CSystemString &)");
	}
}

//	===========================================================================
CBitmapImage::CBitmapImage()
{
	EXPONENT_CLASS_CONSTRUCTION(CBitmapImage);
	m_hasAlpha = false;
}

//	===========================================================================
CBitmapImage::~CBitmapImage()
{
	EXPONENT_CLASS_DESTRUCTION(CBitmapImage);
}

//	===========================================================================
bool CBitmapImage::loadFromFile(const CSystemString &filename)
{
	// Store the filename
	m_filename = filename;

	// Unload the old image
	if (this->hasImageLoaded())
	{
		this->unloadImage();
	}

#ifdef WIN32

	// Load the bitmap image
	m_theBitmap = (HBITMAP) LoadImage (NULL, filename.getString(), IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);

	// Return
	m_imageLoaded  = m_theBitmap != NULL;
	return m_imageLoaded;
#else
	return false;
#endif
}

//	===========================================================================
CBitmapImage *CBitmapImage::getNewInstance(const CSystemString &path, const CString &filename)
{
	// Construct the proper path
	CSystemString theFilename = path;
	theFilename.appendPath(filename);

	// Return the new image
	return new CBitmapImage(theFilename);
}